module net.BurtonRadons.dig.platform.imageLoaderJPEG;

/+
#ifdef DOXYGOWAY
+/

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.common.imageLoader;
private import net.BurtonRadons.dig.platform.windows;
//private import std.stream;
//private import std.c.stdio;

//private import std.c.windows.windows;


private class digCommonJPEGLibrary
{
    const char[] libraryName = "libjpeg.dll";
    static _HANDLE library;

    const uint JPEG_LIB_VERSION = 62; /* Version 6b. */

    const uint DCTSIZE = 8;
    const uint DCTSIZE2 = 64;
    const uint NUM_QUANT_TBLS = 4;
    const uint NUM_HUFF_TBLS = 4;
    const uint NUM_ARITH_TBLS = 16;
    const uint MAX_COMPS_IN_SCAN = 4;
    const uint MAX_SAMP_FACTOR = 4;

    const uint C_MAX_BLOCKS_IN_MCU = 10;
    const uint D_MAX_BLOCKS_IN_MCU = 10;

    alias void *jpeg_memory_mgr;
    alias void *jpeg_progress_mgr;
    alias void *jpeg_saved_marker_ptr;
    alias uint JDIMENSION;
    alias ubyte boolean;
    alias short JCOEF;
    alias ushort _UINT16;
    alias ubyte _UINT8;

    alias void *jpeg_decomp_master;
    alias void *jpeg_d_main_controller;
    alias void *jpeg_d_coef_controller;
    alias void *jpeg_d_post_controller;
    alias void *jpeg_input_controller;
    alias void *jpeg_marker_reader;
    alias void *jpeg_entropy_decoder;
    alias void *jpeg_inverse_dct;
    alias void *jpeg_upsampler;
    alias void *jpeg_color_deconverter;
    alias void *jpeg_color_quantizer;

    alias ubyte JOCTET;

    alias ubyte JSAMPLE;
    alias JSAMPLE *JSAMPROW;	/* ptr to one image row of pixel samples. */
    alias JSAMPROW *JSAMPARRAY;	/* ptr to some rows (a 2-D sample array) */
    alias JSAMPARRAY *JSAMPIMAGE;	/* a 3-D sample array: top index is color */

    typedef JCOEF[DCTSIZE2] JBLOCK; /* one block of coefficients */
    typedef JBLOCK *JBLOCKROW;	/* pointer to one row of coefficient blocks */
    typedef JBLOCKROW *JBLOCKARRAY;		/* a 2-D array of coefficient blocks */
    typedef JBLOCKARRAY *JBLOCKIMAGE;	/* a 3-D array of coefficient blocks */

    typedef JCOEF *JCOEFPTR;	/* useful in a couple of places */

    typedef uint J_COLOR_SPACE;
    enum : J_COLOR_SPACE
    {
	JCS_UNKNOWN,
	JCS_GRAYSCALE,
        JCS_RGB,
	JCS_YCbCr,
	JCS_CMYK,
	JCS_YCCK
    }

    typedef uint J_DCT_METHOD;
    enum : J_DCT_METHOD
    {
        JDCT_ISLOW,
        JDCT_IFAST,
        JDCT_FLOAT
    }

    typedef uint J_DITHER_MODE;
    enum : J_DITHER_MODE
    {
        JDITHER_NONE,
        JDITHER_ORDERED,
        JDITHER_FS
    }

    struct JQUANT_TBL
    {
        _UINT16 [DCTSIZE2] quantval;
        boolean sent_table;
    }

    struct JHUFF_TBL
    {
        _UINT8 bits[17];
        _UINT8 huffval[256];
        boolean sent_table;
    }

    const uint JMSG_LENGTH_MAX = 200;
    const uint JMSG_STR_PARM_MAX = 80;

    struct jpeg_common_fields
    {
        jpeg_error_mgr *err;
        jpeg_memory_mgr *mem;
        jpeg_progress_mgr *progress;
        void *client_data;
        boolean is_decompressor;
        int global_state;
    }

    alias jpeg_common_fields *j_common_ptr;

    struct jpeg_error_mgr
    {
        void function (j_common_ptr cinfo) error_exit;
        void function (j_common_ptr cinfo, int msg_level) emit_message;
        void function (j_common_ptr cinfo) output_message;
        void function (j_common_ptr cinfo, char *buffer) format_message;
        void function (j_common_ptr cinfo) reset_error_mgr;

        int msg_code;
        union MessageParam
        {
            int i [8];
            char s [JMSG_STR_PARM_MAX];
        }
        MessageParam msg_param;
  
        int trace_level;
        int num_warnings;
        char **jpeg_message_table;
        int last_jpeg_message;
        char **addon_message_table;
        int first_addon_message;
        int last_addon_message;
    }

    struct jpeg_component_info
    {
        int component_id;
        int component_index;
        int h_samp_factor;
        int v_samp_factor;
        int quant_tbl_no;
        int dc_tbl_no;
        int ac_tbl_no;
        JDIMENSION width_in_blocks;
        JDIMENSION height_in_blocks;
        int DCT_scaled_size;
        JDIMENSION downsampled_width;
        JDIMENSION downsampled_height;
        boolean component_needed;
        int MCU_width;
        int MCU_height;
        int MCU_blocks;
        int MCU_sample_width;
        int last_col_width;
        int last_row_height;
        JQUANT_TBL *quant_table;
        void *dct_table;
    }

    struct jpeg_decompress_struct
    {
        jpeg_common_fields common;
        jpeg_source_mgr *src;
        JDIMENSION image_width;
        JDIMENSION image_height;
        int num_components;
        J_COLOR_SPACE jpeg_color_space;
        J_COLOR_SPACE out_color_space;
        uint scale_num, scale_denom;
        double output_gamma;
        boolean buffered_image;
        boolean raw_data_out;
        J_DCT_METHOD dct_method;
        boolean do_fancy_upsampling;
        boolean do_block_smoothing;
        boolean quantize_colors;
        J_DITHER_MODE dither_mode;
        boolean two_pass_quantize;
        int desired_number_of_colors;
        boolean enable_1pass_quant;
        boolean enable_external_quant;
        boolean enable_2pass_quant;
        JDIMENSION output_width;
        JDIMENSION output_height;
        int out_color_components;
        int output_components;
        int rec_outbuf_height;
        int actual_number_of_colors;
        JSAMPARRAY colormap;
        JDIMENSION output_scanline;

        int input_scan_number;
        JDIMENSION input_iMCU_row;
        int output_scan_number;
        JDIMENSION output_iMCU_row;
        int [DCTSIZE2] *coef_bits;
        JQUANT_TBL *[NUM_QUANT_TBLS] quant_tbl_ptrs;
        JHUFF_TBL *[NUM_HUFF_TBLS] dc_huff_tbl_ptrs;
        JHUFF_TBL *[NUM_HUFF_TBLS] ac_huff_tbl_ptrs;
        int data_precision;
        jpeg_component_info *comp_info;
        boolean progressive_mode;
        boolean arith_code;
        _UINT8 [NUM_ARITH_TBLS] arith_dc_L;
        _UINT8 [NUM_ARITH_TBLS] arith_dc_U;
        _UINT8 [NUM_ARITH_TBLS] arith_ac_K;
        uint restart_interval;
        boolean saw_JFIF_marker;
        _UINT8 JFIF_major_version;
        _UINT8 JFIF_minor_version;
        _UINT8 density_unit;
        _UINT16 X_density;
        _UINT16 Y_density;
        boolean saw_Adobe_marker;
        _UINT8 Adobe_transform;
        boolean CCIR601_sampling;
        jpeg_saved_marker_ptr marker_list;
        int max_h_samp_factor;
        int max_v_samp_factor;
        int min_DCT_scaled_size;
        JDIMENSION total_iMCU_rows;
        JSAMPLE * sample_range_limit;
        int comps_in_scan;
        jpeg_component_info *[MAX_COMPS_IN_SCAN] cur_comp_info;
        JDIMENSION MCUs_per_row;
        JDIMENSION MCU_rows_in_scan;
        int blocks_in_MCU;
        int [D_MAX_BLOCKS_IN_MCU] MCU_membership;
        int Ss, Se, Ah, Al;
        int unread_marker;
        jpeg_decomp_master * master;
        jpeg_d_main_controller * main;
        jpeg_d_coef_controller * coef;
        jpeg_d_post_controller * post;
        jpeg_input_controller * inputctl;
        jpeg_marker_reader * marker;
        jpeg_entropy_decoder * entropy;
        jpeg_inverse_dct * idct;
        jpeg_upsampler * upsample;
        jpeg_color_deconverter * cconvert;
        jpeg_color_quantizer * cquantize;
        uint smack;
    }

    alias jpeg_decompress_struct *j_decompress_ptr;

    struct jpeg_source_mgr
    {
        JOCTET *next_input_byte;
        int bytes_in_buffer;

        extern (C) void function (j_decompress_ptr cinfo) init_source;
        extern (C) boolean function (j_decompress_ptr cinfo) fill_input_buffer;
        extern (C) void function (j_decompress_ptr cinfo, int num_bytes) skip_input_data;
        extern (C) boolean function (j_decompress_ptr cinfo, int desired) resync_to_restart;
        extern (C) void function (j_decompress_ptr cinfo) term_source;
    }

    static extern (C)
    {
        jpeg_error_mgr *function (jpeg_error_mgr *err) jpeg_std_error;
        void function (j_decompress_ptr cinfo, int ver, SIZE_T structsize) jpeg_CreateDecompress;
        boolean function (j_decompress_ptr cinfo, int desired) jpeg_resync_to_restart;
        int function (j_decompress_ptr cinfo, boolean require_image) jpeg_read_header;
        void function (j_decompress_ptr cinfo) jpeg_calc_output_dimensions;
        boolean function (j_decompress_ptr cinfo) jpeg_start_decompress;
        JDIMENSION function (j_decompress_ptr cinfo, JSAMPARRAY scanlines, JDIMENSION max_lines) jpeg_read_scanlines;
        boolean function (j_decompress_ptr cinfo) jpeg_finish_decompress;
        void function (j_decompress_ptr cinfo) jpeg_destroy_decompress;
    }

    static void jpeg_create_decompress (j_decompress_ptr cinfo) { jpeg_CreateDecompress (cinfo, JPEG_LIB_VERSION, jpeg_decompress_struct.size); }

    static void init ()
    {
        if (library != (_HANDLE) 0)
            return;
        library = std.c.windows.windows.LoadLibraryA (libraryName);
        if (library == (_HANDLE) 0)
            throw new Error ("Couldn't load \"" ~ libraryName ~ "\".");
        load ((void **) &jpeg_std_error, "jpeg_std_error");
        load ((void **) &jpeg_CreateDecompress, "jpeg_CreateDecompress");
        load ((void **) &jpeg_resync_to_restart, "jpeg_resync_to_restart");
        load ((void **) &jpeg_read_header, "jpeg_read_header");
        load ((void **) &jpeg_calc_output_dimensions, "jpeg_calc_output_dimensions");
        load ((void **) &jpeg_start_decompress, "jpeg_start_decompress");
        load ((void **) &jpeg_read_scanlines, "jpeg_read_scanlines");
        load ((void **) &jpeg_finish_decompress, "jpeg_finish_decompress");
        load ((void **) &jpeg_destroy_decompress, "jpeg_destroy_decompress");
    }

    static void load (void** data, char[] name)
    {
        *data = std.c.windows.windows.GetProcAddress (library, std.string.toStringz (name));
        if (*data === null)
            throw new Error ("Couldn't find symbol \"" ~ name ~ "\" in library \"" ~ libraryName ~ "\".");
    }
}

class digCommonImageLoader_jpeg : ImageLoader
{
    override char [] name () { return "JPEG"; }
    override char [] exts () { return "*.jpeg;*.jpg"; }

    override float match ()
    {
        ubyte[10] head;

        if (stream.read (head) != 10)
            return 0;
        if (head [0] == 0xFF && head [1] == 0xD8
         && head [6] == 'J' && head [7] == 'F' 
         && head [8] == 'I' && head [9] == 'F')
            return 1;
        return 0;
    }

    struct our_source_mgr
    {
        digCommonJPEGLibrary.jpeg_source_mgr base;
        std.stream.Stream stream;
        ubyte [] buffer;
    }

    static extern (C) void init_source (digCommonJPEGLibrary.j_decompress_ptr cinfo)
    {
    }

    static extern (C) digCommonJPEGLibrary.boolean fill_input_buffer (digCommonJPEGLibrary.j_decompress_ptr cinfo)
    {
        our_source_mgr *mgr = cast (our_source_mgr *) cinfo.src;

        mgr.base.bytes_in_buffer = mgr.stream.read (mgr.buffer);
        mgr.base.next_input_byte = mgr.buffer;
        return 1;
    }

    static extern (C) void skip_input_data (digCommonJPEGLibrary.j_decompress_ptr cinfo, int count)
    {
        our_source_mgr *mgr = cast (our_source_mgr *) cinfo.src;

        mgr.stream.seekCur (count - mgr.base.bytes_in_buffer);
        fill_input_buffer (cinfo);
    }

    static extern (C) void term_source (digCommonJPEGLibrary.j_decompress_ptr cinfo)
    {
        our_source_mgr *mgr = cast (our_source_mgr *) cinfo.src;

        delete mgr.buffer;
    }

    override void load ()
    {
        digCommonJPEGLibrary.jpeg_error_mgr errorManager;
        digCommonJPEGLibrary.jpeg_decompress_struct reader;
        our_source_mgr manager;

        digCommonJPEGLibrary.init ();
        reader.common.err = digCommonJPEGLibrary.jpeg_std_error (&errorManager);
        digCommonJPEGLibrary.jpeg_create_decompress (&reader);

        manager.base.next_input_byte = null;
        manager.base.bytes_in_buffer = 0;
        manager.base.init_source = &init_source;
        manager.base.fill_input_buffer = &fill_input_buffer;
        manager.base.skip_input_data = &skip_input_data;
        manager.base.resync_to_restart = digCommonJPEGLibrary.jpeg_resync_to_restart;
        manager.base.term_source = &term_source;
        manager.stream = stream;
        manager.buffer = new ubyte [8192];
        reader.src = &manager.base;

        digCommonJPEGLibrary.jpeg_read_header (&reader, 1);
        assert (reader.jpeg_color_space != digCommonJPEGLibrary.JCS_UNKNOWN);

        int iWidth, iHeight, iDepth;
        bit iAlpha;
        char[] iType;
        int bytesPerPixel;

        if (reader.jpeg_color_space == digCommonJPEGLibrary.JCS_GRAYSCALE)
        {
            iType = "luminance";
            bytesPerPixel = 1;
        }
        else
        {
            reader.out_color_space = digCommonJPEGLibrary.JCS_RGB;
            iType = "rgb";
            bytesPerPixel = 3;
        }

        iWidth = reader.image_width;
        iHeight = reader.image_height;
        iDepth = 8;
        iAlpha = false;

        image.dimensions (iWidth, iHeight, iDepth, iType, iAlpha);
        reader.quantize_colors = 0;
        digCommonJPEGLibrary.jpeg_calc_output_dimensions (&reader);
        digCommonJPEGLibrary.jpeg_start_decompress (&reader);

        image.topdown ();

        ubyte[] line = new ubyte [reader.image_width * bytesPerPixel];

        while (reader.output_scanline < reader.output_height)
        {
            ubyte *[1] pointer;

            int index = reader.output_scanline;

            pointer [0] = line;
            digCommonJPEGLibrary.jpeg_read_scanlines (&reader, (digCommonJPEGLibrary.JSAMPARRAY) pointer, 1);
            image.row (index, line);
        }

        delete line;
        digCommonJPEGLibrary.jpeg_finish_decompress (&reader);
        digCommonJPEGLibrary.jpeg_destroy_decompress (&reader);
    }
}

/+
#endif
+/